#ifndef GRAYDECODE_H
#define GRAYDECODE_H

#include "ccrypt.h"

class FastAveragingDecoder : public VirtualDecoder
{
	public:
   		FastAveragingDecoder()
		{
 			_description = "Fast Averaging";
			_outwidth = 360;
			_outheight = 280;
			_use_vbi = true;
		}

   		void decodeFrame(unsigned char *membase, int offset, bool invert_polarity);

		virtual int convertRawXToScreenX(int x) const
			{ return((x-getColorBurstWidth())/5); }

		virtual int convertScreenXToRawX(int x) const
			{ return(x*5+getColorBurstWidth()); }
};


class AveragingDecoder : public VirtualDecoder
{
	public:
   		AveragingDecoder()
		{
 			_description = "Averaging";
			_outwidth = 720;
			_outheight = 280*2;
			_use_vbi = true;
		}

   		void decodeFrame(unsigned char *membase, int offset, bool invert_polarity);

		virtual int convertRawXToScreenX(int x) const
			{ return((x-getColorBurstWidth())* 720/1800); }
		virtual int convertRawYToScreenY(int y) const { return(y*2); }

		virtual int convertScreenXToRawX(int x) const
	        { return(x*1800/720+getColorBurstWidth()); }
		virtual int convertScreenYToRawY(int y) const  { return(y/2); }
};

#endif
